'/***
'*memory.h - declarations for buffer (memory) manipulation routines
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This include file contains the function declarations for the
'*       buffer (memory) manipulation routines.
'*       [System V]
'*
'*       [Public]
'*
'****/

#If Not %Def(%MEMORY_INC)
    %MEMORY_INC = 1

'typedef unsigned int size_t;

'/* Function prototypes */

'_CRTIMP void *  __cdecl _memccpy(void *, const void *, int, unsigned int);
Declare Function memccpy CDecl Lib "msvcrt.dll" Alias "_memccpy" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Dword, _                           ' const void *src
   ByVal Long, _                            ' int  c
   ByVal Dword _                            ' unsigned int count
   ) As Dword                               ' void *

'_CRTIMP void *  __cdecl memchr(const void *, int, size_t);
Declare Function memchr CDecl Lib "msvcrt.dll" Alias "memchr" ( _
   ByVal Dword, _                           ' const void *buf
   ByVal Long, _                            ' int  c
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' void *

'_CRTIMP int     __cdecl _memicmp(const void *, const void *, unsigned int);
Declare Function memicmp CDecl Lib "msvcrt.dll" Alias "_memicmp" ( _
   ByVal Dword, _                           ' const void *buf1
   ByVal Dword, _                           ' const void *buf2
   ByVal Dword _                            ' unsigned int count
   ) As Long                                ' int

'_CRTIMP int     __cdecl memcmp(const void *, const void *, size_t);
Declare Function memcmp CDecl Lib "msvcrt.dll" Alias "memcmp" ( _
   ByVal Dword, _                           ' const void *buf1
   ByVal Dword, _                           ' const void *buf2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP void *  __cdecl memcpy(void *, const void *, size_t);
Declare Function memcpy CDecl Lib "msvcrt.dll" Alias "memcpy" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Dword, _                           ' const void *src
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP void *  __cdecl memset(void *, int, size_t);
Declare Function memset CDecl Lib "msvcrt.dll" Alias "memset" ( _
   ByVal Dword, _                           ' void *dest
   ByVal Long, _                            ' int c
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int


#EndIf   ' #IF NOT %DEF(%MEMORY_INC)